import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'Accept'
 * created in the main() method.
 */
public class Accept extends Form
{
	public Accept()
	{
		super();

		// Required for Visual J++ Form Designer support
		initForm();		

		// TODO: Add any constructor code after initForm call
	}
	
	public void setCaller(String p_id) {
		label1.setText(p_id + " wants a word with you, do you want to accept?");
	}

	/**
	 * Accept overrides dispose so it can clean up the
	 * component list.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void button1_click(Object source, Event e) {
		this.setDialogResult(DialogResult.OK);
	}

	private void button2_click(Object source, Event e) {
		this.setDialogResult(DialogResult.CANCEL);
	}

	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	Button button1 = new Button();
	Button button2 = new Button();
	Label label1 = new Label();

	private void initForm()
	{
		button1.setLocation(new Point(40, 64));
		button1.setSize(new Point(80, 32));
		button1.setTabIndex(1);
		button1.setText("Accept");
		button1.addOnClick(new EventHandler(this.button1_click));

		button2.setLocation(new Point(144, 64));
		button2.setSize(new Point(80, 32));
		button2.setTabIndex(0);
		button2.setText("Reject");
		button2.addOnClick(new EventHandler(this.button2_click));

		this.setText("Incoming Call");
		this.setAcceptButton(button1);
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setCancelButton(button2);
		this.setClientSize(new Point(278, 109));
		this.setShowInTaskbar(false);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);
		this.setTopMost(true);

		label1.setLocation(new Point(32, 16));
		label1.setSize(new Point(184, 32));
		label1.setTabIndex(2);
		label1.setTabStop(false);
		label1.setText("Do you want to accept this call?");

		this.setNewControls(new Control[] {
							label1, 
							button2, 
							button1});
	}

	/**
	 * The main entry point for the application. 
	 *
	 * @param args Array of parameters passed to the application
	 * via the command line.
	 */
	public static void main(String args[])
	{
		Application.run(new Accept());
	}
}
